class NonPlayerCharacter
  def initialize(args, tiled_object)
    raise Exception "second parameter expected to be a Tiled::MapObject" unless tiled_object.class == Tiled::MapObject

    @rect = {
      x: tiled_object.attributes.x.to_i,
      y: tiled_object.attributes.y.to_i,
      w: tiled_object.attributes.width.to_i,
      h: tiled_object.attributes.height.to_i,
      path: "sprites/#{tiled_object.properties.sprite}.png"
    }
  end

  def render
    @rect
  end
end